<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">IT Project Planning</h1>
        <a href="?page=project_create" class="btn btn-primary shadow-sm">
            <i class="bi bi-plus-lg me-2"></i>Buat Proyek Baru
        </a>
    </div>

    <?php if (isset($_GET['message']) && $_GET['message'] == 'create_success'): ?>
        <div class="alert alert-success">Proyek baru berhasil dibuat.</div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Proyek</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Nama Proyek</th>
                            <th>Status</th>
                            <th>Tanggal Mulai</th>
                            <th>Tanggal Selesai</th>
                            <th>Dibuat Oleh</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($projects)): ?>
                            <?php foreach ($projects as $project): ?>
                                <tr>
                                    <td>
                                        <a href="?page=project_show&id=<?php echo htmlspecialchars($project['id_project']); ?>">
                                            <?php echo htmlspecialchars($project['project_name']); ?>
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php 
                                            switch ($project['status']) {
                                                case 'Planning': echo 'secondary'; break;
                                                case 'In Progress': echo 'info'; break;
                                                case 'Completed': echo 'success'; break;
                                                case 'On Hold': echo 'warning'; break;
                                                default: echo 'light';
                                            }
                                        ?>">
                                            <?php echo htmlspecialchars($project['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('d M Y', strtotime($project['start_date'])); ?></td>
                                    <td><?php echo $project['end_date'] ? date('d M Y', strtotime($project['end_date'])) : 'N/A'; ?></td>
                                    <td><?php echo htmlspecialchars($project['created_by_name']); ?></td>
                                    <td>
                                        <a href="?page=project_show&id=<?php echo $project['id_project']; ?>" class="btn btn-info btn-sm">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <!-- Edit and Delete buttons to be added later -->
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center">Belum ada proyek yang dibuat.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
