<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Manajemen Pengguna</h1>

    <?php if (isset($_GET['message'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['message']) {
                    case 'user_added':
                        echo "Pengguna berhasil ditambahkan.";
                        break;
                    case 'user_updated':
                        echo "Pengguna berhasil diperbarui.";
                        break;
                    case 'user_deleted':
                        echo "Pengguna berhasil dihapus.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'user_not_found':
                        echo "Pengguna tidak ditemukan.";
                        break;
                    case 'add_failed':
                        echo "Gagal menambahkan pengguna.";
                        break;
                    case 'update_failed':
                        echo "Gagal memperbarui pengguna.";
                        break;
                    case 'delete_failed':
                        echo "Gagal menghapus pengguna.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Pengguna</h6>
            <a href="?page=users_create" class="btn btn-primary btn-sm">Tambah Pengguna Baru</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Username</th>
                            <th>Nama Lengkap</th>
                            <th>Role</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($users)): ?>
                            <?php foreach ($users as $user): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($user['id_user']); ?></td>
                                    <td><?php echo htmlspecialchars($user['username']); ?></td>
                                    <td><?php echo htmlspecialchars($user['nama_lengkap']); ?></td>
                                    <td><?php echo htmlspecialchars($user['role']); ?></td>
                                    <td>
                                        <a href="?page=users_edit&id=<?php echo $user['id_user']; ?>" class="btn btn-info btn-sm">Edit</a>
                                        <form action="?page=users_delete" method="POST" style="display:inline-block;" onsubmit="return confirm('Anda yakin ingin menghapus pengguna ini?');">
                                            <input type="hidden" name="id_user" value="<?php echo $user['id_user']; ?>">
                                            <button type="submit" class="btn btn-danger btn-sm">Hapus</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center">Tidak ada pengguna ditemukan.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
