<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Tambah Pengguna Baru</h1>

    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'empty_fields':
                        echo "Semua kolom harus diisi.";
                        break;
                    case 'username_exists':
                        echo "Username sudah terdaftar. Pilih username lain.";
                        break;
                    case 'add_failed':
                        echo "Gagal menambahkan pengguna. Silakan coba lagi.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Form Pengguna Baru</h6>
        </div>
        <div class="card-body">
            <form action="?page=users_store" method="POST">
                <div class="mb-3">
                    <label for="username" class="form-label">Username</label>
                    <input type="text" class="form-control" id="username" name="username" required>
                </div>
                <div class="mb-3">
                    <label for="nama_lengkap" class="form-label">Nama Lengkap</label>
                    <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" required>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <input type="password" class="form-control" id="password" name="password" required>
                </div>
                <div class="mb-3">
                    <label for="role" class="form-label">Role</label>
                    <select class="form-control" id="role" name="role" required>
                        <option value="admin">Admin</option>
                        <option value="petugas">Petugas</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Tambah Pengguna</button>
                <a href="?page=users" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>
