<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Manajemen Insiden SLA</h1>

    <?php if (isset($_GET['message'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['message']) {
                    case 'incident_added':
                        echo "Insiden berhasil dicatat.";
                        break;
                    case 'incident_resolved':
                        echo "Insiden berhasil diselesaikan.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'add_failed':
                        echo "Gagal mencatat insiden. Silakan coba lagi.";
                        break;
                    case 'resolve_failed':
                        echo "Gagal menyelesaikan insiden. Silakan coba lagi.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Insiden Layanan</h6>
            <a href="?page=sla_incidents_create" class="btn btn-danger btn-sm">Catat Insiden Baru</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Vendor</th>
                            <th>Deskripsi</th>
                            <th>Waktu Mulai</th>
                            <th>Waktu Selesai</th>
                            <th>Downtime (Menit)</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($incidents)): ?>
                            <?php foreach ($incidents as $incident): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($incident['nama_vendor'] ?? 'N/A'); ?></td>
                                    <td><?php echo htmlspecialchars($incident['incident_description']); ?></td>
                                    <td><?php echo htmlspecialchars($incident['waktu_mulai']); ?></td>
                                    <td><?php echo htmlspecialchars($incident['waktu_selesai'] ?? '-'); ?></td>
                                    <td><?php echo $incident['durasi_downtime_minutes'] ? htmlspecialchars($incident['durasi_downtime_minutes']) : "<span class='text-muted'>Terbuka</span>"; ?></td>
                                    <td>
                                        <?php if (empty($incident['waktu_selesai'])): ?>
                                            <form class="d-inline" action="?page=sla_incidents_resolve" method="POST">
                                                <input type="hidden" name="id_incident" value="<?php echo htmlspecialchars($incident['id_incident']); ?>">
                                                <input type="hidden" name="waktu_mulai" value="<?php echo htmlspecialchars($incident['waktu_mulai']); ?>">
                                                <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('Anda yakin ingin menyelesaikan insiden ini?');">Selesaikan</button>
                                            </form>
                                        <?php else: ?>
                                            Selesai
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center">Belum ada insiden tercatat.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
