<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Catat Insiden SLA Baru</h1>

    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'add_failed':
                        echo "Gagal mencatat insiden. Silakan coba lagi.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-danger">Form Catat Insiden Baru</h6>
        </div>
        <div class="card-body">
            <form action="?page=sla_incidents_store" method="POST">
                <div class="mb-3">
                    <label for="id_vendor" class="form-label">Vendor</label>
                    <select name="id_vendor" id="id_vendor" class="form-select" required>
                        <option value="">-- Pilih Vendor --</option>
                        <?php if (!empty($vendors_for_incident_form)): ?>
                            <?php foreach ($vendors_for_incident_form as $vendor): ?>
                                <option value="<?php echo htmlspecialchars($vendor['id_vendor']); ?>"><?php echo htmlspecialchars($vendor['nama_vendor']); ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="incident_description" class="form-label">Deskripsi Insiden</label>
                    <textarea name="incident_description" id="incident_description" class="form-control" rows="3" placeholder="Deskripsi Singkat Insiden" required></textarea>
                </div>
                <div class="mb-3">
                    <label for="waktu_mulai" class="form-label">Waktu Mulai Insiden</label>
                    <input type="datetime-local" name="waktu_mulai" id="waktu_mulai" class="form-control" value="<?php echo date('Y-m-d\TH:i'); ?>" required>
                </div>
                <button type="submit" class="btn btn-danger">Catat Insiden</button>
                <a href="?page=sla_incidents" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>
