<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Form Penilaian Maintenance untuk Aset: <?php echo htmlspecialchars($asset_data->nama_perangkat); ?></h1>

    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'add_failed':
                        echo "Gagal menambahkan riwayat maintenance dan penilaian. Silakan coba lagi.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Informasi Aset</h6>
        </div>
        <div class="card-body">
            <p><strong>Serial Number:</strong> <?php echo htmlspecialchars($asset_data->serial_number); ?></p>
            <p><strong>Kategori:</strong> <?php echo htmlspecialchars($asset_data->kategori); ?></p>
            <p><strong>Lokasi:</strong> <?php echo htmlspecialchars($asset_data->lokasi); ?></p>
            <p><strong>PIC:</strong> <?php echo htmlspecialchars($asset_data->pic); ?></p>
        </div>
    </div>

    <form id="maintenanceForm" action="?page=add_maintenance_process" method="POST">
        <input type="hidden" name="id_aset" value="<?php echo htmlspecialchars($asset_data->id_aset); ?>">
        <input type="hidden" name="asset_category" value="<?php echo htmlspecialchars($asset_data->kategori); ?>">
        <input type="hidden" name="assessment_data" id="assessment_data_input">

        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Data Maintenance Umum</h6>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="tanggal_maintenance" class="form-label">Tanggal Pengecekan</label>
                    <input type="date" class="form-control" id="tanggal_maintenance" name="tanggal_maintenance" value="<?php echo date('Y-m-d'); ?>" required>
                </div>
                
                <div class="mb-3">
                    <label for="tindakan" class="form-label">Tindakan</label>
                    <input type="text" class="form-control" id="tindakan" name="tindakan" placeholder="e.g., Cleaning, Service, Ganti part" required>
                </div>
                
                <div class="mb-3">
                    <label for="nama_teknisi" class="form-label">Nama Teknisi</label>
                    <input type="text" class="form-control" id="nama_teknisi" name="nama_teknisi" value="<?php echo htmlspecialchars($_SESSION['nama_lengkap'] ?? ''); ?>" required>
                </div>
                
                <div class="mb-3">
                    <label for="catatan_teknisi" class="form-label">Catatan Teknisi</label>
                    <textarea class="form-control" id="catatan_teknisi" name="catatan_teknisi" rows="3"></textarea>
                </div>

                <div class="mb-3">
                    <label for="status_aset_baru" class="form-label">Update Status Aset</label>
                    <select class="form-select" id="status_aset_baru" name="status_aset_baru">
                        <?php 
                        $st = ['Aktif', 'Rusak', 'Dismantle', 'Maintenance'];
                        foreach ($st as $s) {
                            $selected = ($asset_data->status_aset == $s) ? 'selected' : '';
                            echo "<option value='{$s}' {$selected}>{$s}</option>";
                        }
                        ?>
                    </select>
                </div>
            </div>
        </div>

        <!-- Dynamic Assessment Form based on Category -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Detail Penilaian Aset (Kategori: <?php echo htmlspecialchars($asset_data->kategori); ?>)</h6>
            </div>
            <div class="card-body">
                <?php if ($asset_data->kategori === 'PC' || $asset_data->kategori === 'Laptop' || $asset_data->kategori === 'AIO'): ?>
                    <!-- PC / Laptop / AIO Assessment -->
                    <h5 class="mt-3">1. Kondisi Fisik</h5>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Chassis / casing</label>
                            <select class="form-select" name="assessment[kondisi_fisik][chassis]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Baik">Baik</option>
                                <option value="Retak">Retak</option>
                                <option value="Penyok">Penyok</option>
                                <option value="Longgar">Longgar</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Kebersihan body</label>
                            <select class="form-select" name="assessment[kondisi_fisik][kebersihan_body]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Bersih">Bersih</option>
                                <option value="Berdebu">Berdebu</option>
                                <option value="Kotor">Kotor</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Kondisi layar (screen) – khusus laptop/AIO</label>
                            <select class="form-select" name="assessment[kondisi_fisik][kondisi_layar]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Baik">Baik</option>
                                <option value="Dead pixel">Dead pixel</option>
                                <option value="Goresan">Goresan</option>
                                <option value="Shadow">Shadow</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Kondisi keyboard</label>
                            <select class="form-select" name="assessment[kondisi_fisik][kondisi_keyboard]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Beberapa tombol tidak fungsi">Beberapa tombol tidak fungsi</option>
                                <option value="Patah">Patah</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Kondisi touchpad/mouse</label>
                            <select class="form-select" name="assessment[kondisi_fisik][kondisi_touchpad_mouse]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Tidak fungsi">Tidak fungsi</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Engsel laptop</label>
                            <select class="form-select" name="assessment[kondisi_fisik][engsel_laptop]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Kencang">Kencang</option>
                                <option value="Longgar">Longgar</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Port USB / LAN / Audio</label>
                            <select class="form-select" name="assessment[kondisi_fisik][port_konektor]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Beberapa tidak fungsi">Beberapa tidak fungsi</option>
                                <option value="Rusak fisik">Rusak fisik</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Kondisi kabel power & adaptor</label>
                            <select class="form-select" name="assessment[kondisi_fisik][kabel_power]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Baik">Baik</option>
                                <option value="Rusak">Rusak</option>
                                <option value="Original">Original</option>
                                <option value="KW">KW</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Kondisi fan & ventilasi</label>
                            <select class="form-select" name="assessment[kondisi_fisik][fan_ventilasi]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Bersih">Bersih</option>
                                <option value="Berdebu">Berdebu</option>
                                <option value="Bising">Bising</option>
                            </select>
                        </div>
                    </div>

                    <h5 class="mt-3">2. Kondisi Hardware Internal</h5>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Suhu CPU</label>
                            <select class="form-select" name="assessment[kondisi_hardware_internal][suhu_cpu]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Overheat">Overheat</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Suhu GPU</label>
                            <select class="form-select" name="assessment[kondisi_hardware_internal][suhu_gpu]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Overheat">Overheat</option>
                                <option value="Tidak ada GPU">Tidak ada GPU</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">RAM</label>
                            <select class="form-select" name="assessment[kondisi_hardware_internal][ram]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Error">Error</option>
                                <option value="Kapasitas">Kapasitas</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Storage (HDD/SSD health)</label>
                            <select class="form-select" name="assessment[kondisi_hardware_internal][storage_health]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Baik">Baik</option>
                                <option value="Warning">Warning</option>
                                <option value="Bad">Bad</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Kinerja sistem</label>
                            <select class="form-select" name="assessment[kondisi_hardware_internal][kinerja_sistem]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Lambat">Lambat</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Kondisi PSU</label>
                            <select class="form-select" name="assessment[kondisi_hardware_internal][kondisi_psu]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Bising">Bising</option>
                                <option value="Tidak stabil">Tidak stabil</option>
                                <option value="Tidak ada">Tidak ada</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Battery health</label>
                            <select class="form-select" name="assessment[kondisi_hardware_internal][battery_health]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Baik">Baik</option>
                                <option value="Sedang">Sedang</option>
                                <option value="Jelek">Jelek</option>
                                <option value="Tidak ada">Tidak ada</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Kondisi WiFi adapter</label>
                            <select class="form-select" name="assessment[kondisi_hardware_internal][wifi_adapter]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Tidak stabil">Tidak stabil</option>
                                <option value="Tidak ada">Tidak ada</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Kondisi LAN card</label>
                            <select class="form-select" name="assessment[kondisi_hardware_internal][lan_card]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Rusak">Rusak</option>
                                <option value="Tidak ada">Tidak ada</option>
                            </select>
                        </div>
                    </div>

                    <h5 class="mt-3">3. Performa & Fungsional</h5>
                    <div class="mb-3">
                        <label class="form-label">Boot speed</label>
                        <select class="form-select" name="assessment[performa_fungsional][boot_speed]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Lambat">Lambat</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Aplikasi standar berjalan lancar</label>
                        <select class="form-select" name="assessment[performa_fungsional][aplikasi_standar]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Ya">Ya</option>
                            <option value="Tidak">Tidak</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Internet & jaringan stabil</label>
                        <select class="form-select" name="assessment[performa_fungsional][internet_jaringan]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Stabil">Stabil</option>
                            <option value="Tidak stabil">Tidak stabil</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tidak ada freeze, blue screen, atau restart tiba-tiba</label>
                        <select class="form-select" name="assessment[performa_fungsional][stabilitas_sistem]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Tidak ada">Tidak ada</option>
                            <option value="Ada">Ada</option>
                        </select>
                    </div>

                    <h5 class="mt-3">4. Software & Keamanan</h5>
                    <div class="mb-3">
                        <label class="form-label">Status antivirus</label>
                        <select class="form-select" name="assessment[software_keamanan][status_antivirus]">
                            <option value="">Pilih Status</option>
                            <option value="Aktif">Aktif</option>
                            <option value="Tidak aktif">Tidak aktif</option>
                            <option value="Tidak ada">Tidak ada</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Windows update / OS update</label>
                        <select class="form-select" name="assessment[software_keamanan][os_update]">
                            <option value="">Pilih Status</option>
                            <option value="Terbaru">Terbaru</option>
                            <option value="Perlu update">Perlu update</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Aktivasi OS & Office</label>
                        <select class="form-select" name="assessment[software_keamanan][aktivasi_os_office]">
                            <option value="">Pilih Status</option>
                            <option value="Aktif">Aktif</option>
                            <option value="Tidak aktif">Tidak aktif</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Lisensi software</label>
                        <select class="form-select" name="assessment[software_keamanan][lisensi_software]">
                            <option value="">Pilih Status</option>
                            <option value="Asli">Asli</option>
                            <option value="Bajakan">Bajakan</option>
                            <option value="Tidak relevan">Tidak relevan</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Error log / virus terdeteksi</label>
                        <select class="form-select" name="assessment[software_keamanan][error_virus_log]">
                            <option value="">Pilih Status</option>
                            <option value="Tidak ada">Tidak ada</option>
                            <option value="Ada">Ada</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Backup tersedia</label>
                        <select class="form-select" name="assessment[software_keamanan][backup_tersedia]">
                            <option value="">Pilih Status</option>
                            <option value="Ya">Ya</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Tidak wajib">Tidak wajib</option>
                        </select>
                    </div>

                    <h5 class="mt-3">5. Kebersihan & Maintenance</h5>
                    <div class="mb-3">
                        <label class="form-label">Pembersihan debu internal</label>
                        <select class="form-select" name="assessment[kebersihan_maintenance][pembersihan_debu_internal]">
                            <option value="">Pilih Status</option>
                            <option value="Ya">Ya</option>
                            <option value="Tidak">Tidak</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Pembersihan fan/heatsink</label>
                        <select class="form-select" name="assessment[kebersihan_maintenance][pembersihan_fan_heatsink]">
                            <option value="">Pilih Status</option>
                            <option value="Ya">Ya</option>
                            <option value="Tidak">Tidak</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Penggantian thermal paste</label>
                        <select class="form-select" name="assessment[kebersihan_maintenance][penggantian_thermal_paste]">
                            <option value="">Pilih Status</option>
                            <option value="Ya">Ya</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Tidak perlu">Tidak perlu</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Pengecekan kabel internal</label>
                        <select class="form-select" name="assessment[kebersihan_maintenance][pengecekan_kabel_internal]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Baik">Baik</option>
                            <option value="Longgar">Longgar</option>
                            <option value="Rusak">Rusak</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Pengecekan suara kipas</label>
                        <select class="form-select" name="assessment[kebersihan_maintenance][suara_kipas]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Bising">Bising</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Pengecekan UPS</label>
                        <select class="form-select" name="assessment[kebersihan_maintenance][pengecekan_ups]">
                            <option value="">Pilih Status</option>
                            <option value="Normal">Normal</option>
                            <option value="Tidak fungsi">Tidak fungsi</option>
                            <option value="Tidak terhubung">Tidak terhubung</option>
                        </select>
                    </div>

                <?php elseif ($asset_data->kategori === 'Printer'): ?>
                    <!-- Printer Assessment -->
                    <h5 class="mt-3">1. Kondisi Fisik</h5>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Body printer</label>
                            <select class="form-select" name="assessment[kondisi_fisik][body_printer]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Baik">Baik</option>
                                <option value="Retak">Retak</option>
                                <option value="Gores">Gores</option>
                                <option value="Bantingan">Bantingan</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Kebersihan luar</label>
                            <select class="form-select" name="assessment[kondisi_fisik][kebersihan_luar]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Bersih">Bersih</option>
                                <option value="Berdebu">Berdebu</option>
                                <option value="Bertinta">Bertinta</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Paper tray / feeder</label>
                            <select class="form-select" name="assessment[kondisi_fisik][paper_tray_feeder]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Rusak">Rusak</option>
                                <option value="Patah">Patah</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Cover cartridge / toner</label>
                            <select class="form-select" name="assessment[kondisi_fisik][cover_cartridge_toner]">
                                <option value="">Pilih Kondisi</option>
                                <option value="Normal">Normal</option>
                                <option value="Rusak">Rusak</option>
                                <option value="Longgar">Longgar</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                                                    <label class="form-label">Kabel power & USB/LAN</label>
                                                    <select class="form-select" name="assessment[kondisi_fisik][kabel_konektor]">
                                                        <option value="">Pilih Kondisi</option>
                                                        <option value="Baik">Baik</option>
                                                        <option value="Rusak">Rusak</option>
                                                        <option value="Hilang">Hilang</option>
                                                    </select>                    </div>

                    <h5 class="mt-3">2. Performa Printing</h5>
                    <div class="mb-3">
                        <label class="form-label">Test print normal / tidak</label>
                        <select class="form-select" name="assessment[performa_printing][test_print]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Tidak">Tidak</option>
                        </select>
                    </div>
                    <h6 class="mt-2">Hasil print:</h6>
                    <div class="mb-3">
                        <label class="form-label">Tinta putus-putus / tidak keluar</label>
                        <select class="form-select" name="assessment[performa_printing][tinta_putus_tidak_keluar]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Ya">Ya</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Garis-garis (banding)</label>
                        <select class="form-select" name="assessment[performa_printing][garis_banding]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Ya">Ya</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Warna tidak akurat</label>
                        <select class="form-select" name="assessment[performa_printing][warna_tidak_akurat]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Ya">Ya</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Blur/ghosting</label>
                        <select class="form-select" name="assessment[performa_printing][blur_ghosting]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Ya">Ya</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kertas miring</label>
                        <select class="form-select" name="assessment[performa_printing][kertas_miring]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Ya">Ya</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kertas kusut (paper jam)</label>
                        <select class="form-select" name="assessment[performa_printing][kertas_kusut_paper_jam]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Ya">Ya</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Bercak tinta / toner</label>
                        <select class="form-select" name="assessment[performa_printing][bercak_tinta_toner]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Ya">Ya</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kecepatan print normal / lambat</label>
                        <select class="form-select" name="assessment[performa_printing][kecepatan_print]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Lambat">Lambat</option>
                        </select>
                    </div>

                    <h5 class="mt-3">3. Mekanis & Sensor</h5>
                    <div class="mb-3">
                        <label class="form-label">Kondisi roller</label>
                        <select class="form-select" name="assessment[mekanis_sensor][kondisi_roller]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Aus">Aus</option>
                            <option value="Licin">Licin</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kondisi pick-up roller</label>
                        <select class="form-select" name="assessment[mekanis_sensor][kondisi_pickup_roller]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Rusak">Rusak</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Sensor kertas</label>
                        <select class="form-select" name="assessment[mekanis_sensor][sensor_kertas]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Error">Error</option>
                            <option value="Not detected">Not detected</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Suara mesin</label>
                        <select class="form-select" name="assessment[mekanis_sensor][suara_mesin]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Berisik">Berisik</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Gear & mekanik normal</label>
                        <select class="form-select" name="assessment[mekanis_sensor][gear_mekanik]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Rusak">Rusak</option>
                        </select>
                    </div>

                    <h5 class="mt-3">4. Status Consumable</h5>
                    <div class="mb-3">
                        <label class="form-label">Tinta / toner level</label>
                        <select class="form-select" name="assessment[status_consumable][tinta_toner_level]">
                            <option value="">Pilih Level</option>
                            <option value="Penuh">Penuh</option>
                            <option value="Sedang">Sedang</option>
                            <option value="Low">Low</option>
                            <option value="Kosong">Kosong</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kondisi tinta</label>
                        <select class="form-select" name="assessment[status_consumable][kondisi_tinta]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Original">Original</option>
                            <option value="Isian">Isian</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Drum unit</label>
                        <select class="form-select" name="assessment[status_consumable][drum_unit]">
                            <option value="">Pilih Kondisi</option>
                            <option value="OK">OK</option>
                            <option value="Perlu diganti">Perlu diganti</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Maintenance kit</label>
                        <select class="form-select" name="assessment[status_consumable][maintenance_kit]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Baik">Baik</option>
                            <option value="Perlu diganti">Perlu diganti</option>
                            <option value="Tidak ada">Tidak ada</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Waste ink pad</label>
                        <select class="form-select" name="assessment[status_consumable][waste_ink_pad]">
                            <option value="">Pilih Kondisi</option>
                            <option value="Normal">Normal</option>
                            <option value="Penuh">Penuh</option>
                            <option value="Tidak ada">Tidak ada</option>
                        </select>
                    </div>

                    <h5 class="mt-3">5. Konektivitas</h5>
                    <div class="mb-3">
                        <label class="form-label">USB connection:</label>
                        <select class="form-select" name="assessment[konektivitas][usb_connection]">
                            <option value="">Pilih Status</option>
                            <option value="OK">OK</option>
                            <option value="Not OK">Not OK</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">LAN/WiFi:</label>
                        <select class="form-select" name="assessment[konektivitas][lan_wifi]">
                            <option value="">Pilih Status</option>
                            <option value="OK">OK</option>
                            <option value="Not OK">Not OK</option>
                            <option value="Tidak ada">Tidak ada</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Status network printer</label>
                        <select class="form-select" name="assessment[konektivitas][status_network_printer]">
                            <option value="">Pilih Status</option>
                            <option value="Normal">Normal</option>
                            <option value="Offline">Offline</option>
                            <option value="Tidak terhubung">Tidak terhubung</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">IP conflict / tidak terbaca network</label>
                        <select class="form-select" name="assessment[konektivitas][ip_conflict]">
                            <option value="">Pilih Status</option>
                            <option value="Tidak ada">Tidak ada</option>
                            <option value="Ada">Ada</option>
                        </select>
                    </div>

                    <h5 class="mt-3">6. Software & Firmware</h5>
                    <div class="mb-3">
                        <label class="form-label">Driver up to date</label>
                        <select class="form-select" name="assessment[software_firmware][driver_up_to_date]">
                            <option value="">Pilih Status</option>
                            <option value="Ya">Ya</option>
                            <option value="Tidak">Tidak</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Error code muncul?</label>
                        <select class="form-select" name="assessment[software_firmware][error_code]">
                            <option value="">Pilih Status</option>
                            <option value="Tidak ada">Tidak ada</option>
                            <option value="Ada (sebutkan)">Ada (sebutkan)</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Firmware up to date</label>
                        <select class="form-select" name="assessment[software_firmware][firmware_up_to_date]">
                            <option value="">Pilih Status</option>
                            <option value="Ya">Ya</option>
                            <option value="Tidak">Tidak</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Sharing via server</label>
                        <select class="form-select" name="assessment[software_firmware][sharing_via_server]">
                            <option value="">Pilih Status</option>
                            <option value="Normal">Normal</option>
                            <option value="Tidak">Tidak</option>
                            <option value="Tidak relevan">Tidak relevan</option>
                        </select>
                    </div>

                    <h5 class="mt-3">7. Maintenance Periodik</h5>
                    <div class="mb-3">
                        <label class="form-label">Head cleaning</label>
                        <select class="form-select" name="assessment[maintenance_periodik][head_cleaning]">
                            <option value="">Pilih Status</option>
                            <option value="Dilakukan">Dilakukan</option>
                            <option value="Tidak dilakukan">Tidak dilakukan</option>
                            <option value="Tidak relevan">Tidak relevan</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Roller cleaning</label>
                        <select class="form-select" name="assessment[maintenance_periodik][roller_cleaning]">
                            <option value="">Pilih Status</option>
                            <option value="Dilakukan">Dilakukan</option>
                            <option value="Tidak dilakukan">Tidak dilakukan</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kalibrasi warna</label>
                        <select class="form-select" name="assessment[maintenance_periodik][kalibrasi_warna]">
                            <option value="">Pilih Status</option>
                            <option value="Dilakukan">Dilakukan</option>
                            <option value="Tidak dilakukan">Tidak dilakukan</option>
                            <option value="Tidak relevan">Tidak relevan</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Cleaning internal</label>
                        <select class="form-select" name="assessment[maintenance_periodik][cleaning_internal]">
                            <option value="">Pilih Status</option>
                            <option value="Dilakukan">Dilakukan</option>
                            <option value="Tidak dilakukan">Tidak dilakukan</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Reset counter</label>
                        <select class="form-select" name="assessment[maintenance_periodik][reset_counter]">
                            <option value="">Pilih Status</option>
                            <option value="Dilakukan">Dilakukan</option>
                            <option value="Tidak dilakukan">Tidak dilakukan</option>
                            <option value="Tidak perlu">Tidak perlu</option>
                        </select>
                    </div>

                <?php else: ?>
                    <div class="alert alert-warning">Form penilaian detail tidak tersedia untuk kategori aset ini (<?php echo htmlspecialchars($asset_data->kategori); ?>). Hanya form umum yang akan disimpan.</div>
                <?php endif; ?>

                <h5 class="mt-3">Status Akhir</h5>
                <div class="mb-3">
                    <label class="form-label">Kondisi Akhir</label>
                    <select class="form-select" id="final_condition_select_display" disabled required> <!-- Added disabled and changed ID -->
                        <option value="">Pilih Kondisi</option>
                        <option value="Baik">Baik</option>
                        <option value="Perlu Perbaikan">Perlu Perbaikan</option>
                        <option value="Rusak">Rusak</option>
                        <option value="Perlu Penggantian">Perlu Penggantian</option>
                        <option value="Perlu Maintenance">Perlu Maintenance</option>
                    </select>
                    <input type="hidden" id="final_condition_select_hidden" name="assessment[status_akhir][kondisi]"> <!-- Hidden input for submission -->
                </div>
                <div class="mb-3">
                    <label class="form-label">Rekomendasi teknisi</label>
                    <textarea class="form-control" name="assessment[status_akhir][rekomendasi_teknisi]" rows="3"></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Estimasi umur pakai tersisa</label>
                    <input type="text" class="form-control" name="assessment[status_akhir][estimasi_umur_pakai_sisa]" placeholder="e.g., 2 tahun / 6 bulan / Tidak ada">
                </div>
            </div>
        </div>

        <button type="submit" class="btn btn-success mt-3">Simpan Riwayat & Penilaian</button>
        <a href="?page=maintenance&id=<?php echo htmlspecialchars($asset_data->id_aset); ?>" class="btn btn-secondary mt-3">Batal</a>
    </form>
</div>

<script>
    document.getElementById('maintenanceForm').addEventListener('submit', function(event) {
        const form = event.target;
        const assessmentInputs = form.querySelectorAll('[name^="assessment["]');
        let assessmentData = {};

        assessmentInputs.forEach(input => {
            // Extract the nested keys from the input name, e.g., "assessment[kondisi_fisik][chassis]"
            const nameParts = input.name.match(/assessment\[(.*?)\]\[(.*?)\]/);
            if (nameParts && nameParts.length === 3) {
                const category = nameParts[1];
                const item = nameParts[2];
                if (!assessmentData[category]) {
                    assessmentData[category] = {};
                }
                assessmentData[category][item] = input.value;
            } else {
                // Handle status_akhir which might just be assessment[status_akhir][kondisi]
                const statusAkhirName = input.name.match(/assessment\[status_akhir\]\[(.*?)\]/);
                if (statusAkhirName && statusAkhirName.length === 2) {
                    if (!assessmentData['status_akhir']) {
                        assessmentData['status_akhir'] = {};
                    }
                    assessmentData['status_akhir'][statusAkhirName[1]] = input.value;
                }
            }
        });

        // Set the JSON string to the hidden input
        document.getElementById('assessment_data_input').value = JSON.stringify(assessmentData);
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const assessmentDropdowns = document.querySelectorAll('select[name^="assessment["]:not([name="assessment[status_akhir][kondisi]"])');
        const finalConditionSelectDisplay = document.getElementById('final_condition_select_display');
        const finalConditionSelectHidden = document.getElementById('final_condition_select_hidden'); // New

        function updateFinalCondition() {
            let hasMajorIssue = false;
            let hasMinorIssue = false;
            let allGood = true;

            assessmentDropdowns.forEach(dropdown => {
                const value = dropdown.value;
                if (value && value !== 'Pilih Kondisi' && value !== 'Baik' && value !== 'Normal' && value !== 'Tidak ada' && value !== 'OK' && value !== 'Ya' && value !== 'Tidak perlu' && value !== 'Tidak relevan') {
                    // This is a simplified rule. "Problematic" values.
                    hasMinorIssue = true;
                    if (value.includes('Rusak') || value.includes('Penyok') || value.includes('Retak') || value.includes('Error') || value.includes('Lambat') || value.includes('Tidak fungsi') || value.includes('Overheat') || value.includes('Bad') || value.includes('Perlu update') || value.includes('Tidak aktif') || value.includes('Tidak stabil') || value.includes('Patah') || value.includes('Bising') || value.includes('Bertinta') || value.includes('Gores') || value.includes('Bantingan') || value.includes('Hilang') || value.includes('Aus') || value.includes('Licin') || value.includes('Not OK') || value.includes('Perlu diganti')) {
                        hasMajorIssue = true;
                    }
                }
                if (value && value !== 'Baik' && value !== 'Normal' && value !== 'Tidak ada' && value !== 'OK' && value !== 'Ya' && value !== 'Tidak perlu' && value !== 'Tidak relevan' && value !== 'Pilih Kondisi') {
                    allGood = false;
                }
            });

            const newValue = (hasMajorIssue) ? 'Rusak' : ((hasMinorIssue) ? 'Perlu Perbaikan' : ((allGood) ? 'Baik' : ''));
            finalConditionSelectDisplay.value = newValue;
            finalConditionSelectHidden.value = newValue; // Update hidden input
        }

        // Add event listeners to all assessment dropdowns
        assessmentDropdowns.forEach(dropdown => {
            dropdown.addEventListener('change', updateFinalCondition);
        });

        // Run once on load to set initial state if values are pre-filled (e.g., on edit)
        updateFinalCondition(); 
    });
</script>