<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Detail Aset & Riwayat Maintenance</h1>

    <?php if (isset($_GET['message']) && $_GET['message'] == 'maintenance_added'): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            Riwayat maintenance berhasil ditambahkan!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'asset_id_missing':
                        echo "ID Aset tidak ditemukan.";
                        break;
                    case 'asset_not_found':
                        echo "Aset tidak ditemukan.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>


    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Informasi Aset</h6>
        </div>
        <div class="card-body">
            <p><strong>Nama Perangkat:</strong> <?php echo htmlspecialchars($asset->nama_perangkat); ?></p>
            <p><strong>Serial Number:</strong> <?php echo htmlspecialchars($asset->serial_number); ?></p>
            <p><strong>Kategori:</strong> <?php echo htmlspecialchars($asset->kategori); ?></p>
            <p><strong>Lokasi:</strong> <?php echo htmlspecialchars($asset->lokasi); ?></p>
            <p><strong>PIC:</strong> <?php echo htmlspecialchars($asset->pic); ?></p>
            <p><strong>Status Aset:</strong> <?php echo htmlspecialchars($asset->status_aset); ?></p>
            <p><strong>Tanggal Pembelian:</strong> <?php echo htmlspecialchars($asset->tanggal_pembelian); ?></p>
            <p><strong>Nilai Pembelian:</strong> <?php echo number_format($asset->nilai_pembelian, 2, ',', '.'); ?></p>
            <p><strong>Umur Pakai:</strong> <?php echo htmlspecialchars($asset->life_cycle_years); ?> tahun</p>
            <!-- Add other asset details as needed -->
            <a href="?page=maintenance_form&id_aset=<?php echo htmlspecialchars($asset->id_aset); ?>" class="btn btn-primary mt-3">Lakukan Maintenance Baru</a>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Riwayat Maintenance</h6>
        </div>
        <div class="card-body">
            <?php if (!empty($maintenance_history)): ?>
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Tanggal</th>
                                <th>Tindakan</th>
                                <th>Teknisi</th>
                                <th>Catatan</th>
                                <th>Kondisi Akhir</th>
                                <th>Detail Penilaian</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($maintenance_history as $history): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($history['tanggal_maintenance']); ?></td>
                                    <td><?php echo htmlspecialchars($history['tindakan']); ?></td>
                                    <td><?php echo htmlspecialchars($history['nama_teknisi']); ?></td>
                                    <td><?php echo nl2br(htmlspecialchars($history['catatan_teknisi'])); ?></td>
                                    <td>
                                        <?php
                                            $kondisi_akhir = 'N/A';
                                            if (isset($history['assessment_data']) && !empty($history['assessment_data'])) {
                                                $assessment = json_decode($history['assessment_data'], true);
                                                if (isset($assessment['status_akhir']['kondisi'])) {
                                                    $kondisi_akhir = $assessment['status_akhir']['kondisi'];
                                                }
                                            }
                                            echo htmlspecialchars($kondisi_akhir);
                                        ?>
                                    </td>
                                    <td>
                                        <!-- Link to show assessment details if available -->
                                        <?php if (isset($history['assessment_data']) && !empty($history['assessment_data'])): ?>
                                            <button type="button" class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#assessmentModal<?php echo $history['id_maintenance']; ?>">
                                                Lihat Penilaian
                                            </button>

                                            <!-- Modal for Assessment Details -->
                                            <div class="modal fade" id="assessmentModal<?php echo $history['id_maintenance']; ?>" tabindex="-1" aria-labelledby="assessmentModalLabel<?php echo $history['id_maintenance']; ?>" aria-hidden="true">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="assessmentModalLabel<?php echo $history['id_maintenance']; ?>">Detail Penilaian Maintenance</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <?php
                                                                $assessment = json_decode($history['assessment_data'], true);
                                                                if ($assessment):
                                                                    foreach ($assessment as $section_title => $section_data):
                                                                        echo "<h6>" . ucwords(str_replace('_', ' ', $section_title)) . "</h6>";
                                                                        echo "<ul>";
                                                                        foreach ($section_data as $key => $value):
                                                                            echo "<li><strong>" . ucwords(str_replace('_', ' ', $key)) . ":</strong> " . htmlspecialchars($value) . "</li>";
                                                                        endforeach;
                                                                        echo "</ul>";
                                                                    endforeach;
                                                                else:
                                                                    echo "<p>Tidak ada detail penilaian yang tersimpan atau format tidak valid.</p>";
                                                                endif;
                                                            ?>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            Tidak Ada
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info">Belum ada riwayat maintenance untuk aset ini.</div>
            <?php endif; ?>
        </div>
    </div>
</div>
