<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SI-INAL Asset IT</title>
    <!-- Inter Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- Optional: Custom CSS to override or add styles -->
    <link rel="stylesheet" href="/SI-INAL/public/assets/css/style.css">
</head>
<body class="bg-light-neumorphic">
    <?php if (isset($_SESSION['user_id'])): ?>
    <!-- Main Header Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark-navy-header py-3 px-4 shadow-sm">
        <div class="container-fluid">
            <!-- Logo on the left -->
            <a class="navbar-brand text-white fw-bold fs-4 me-auto" href="?page=home">SI-INAL</a>

            <!-- Right-aligned icons -->
            <div class="d-flex align-items-center ms-auto">
                <a href="#" class="btn btn-link text-white text-decoration-none me-3"><i class="bi bi-bell fs-5"></i></a>
                <a href="#" class="btn btn-link text-white text-decoration-none me-3"><i class="bi bi-chat-text fs-5"></i></a>
                <div class="dropdown">
                    <a href="#" class="d-block link-light text-decoration-none dropdown-toggle" id="dropdownUser1" data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="https://via.placeholder.com/32/FFFFFF/000000?text=U" alt="mdo" width="32" height="32" class="rounded-circle">
                    </a>
                    <ul class="dropdown-menu text-small shadow" aria-labelledby="dropdownUser1">
                        <li><a class="dropdown-item" href="#">Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="?page=logout">Sign out</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content Area -->
    <div class="container-fluid py-4 main-content-neumorphic">
        <?php echo $content; ?>
    </div>

    <!-- Footer with Navigation -->
    <footer class="footer mt-auto py-3 bg-dark-navy-header text-white">
        <div class="container-fluid">
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-4 g-3">
                <div class="col">
                    <h6 class="text-white mb-3">General</h6>
                    <ul class="nav flex-column">
                        <li class="nav-item mb-2"><a href="?page=home" class="nav-link p-0 text-white"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a></li>
                        <li class="nav-item mb-2"><a href="?page=maintenance_history" class="nav-link p-0 text-white"><i class="bi bi-clock-history me-2"></i> Riwayat Maintenance</a></li>
                        <li class="nav-item mb-2"><a href="?page=scan" class="nav-link p-0 text-white"><i class="bi bi-qr-code-scan me-2"></i> Scan QR</a></li>
                        <li class="nav-item mb-2"><a href="?page=helpdesk_tickets" class="nav-link p-0 text-white"><i class="bi bi-headset me-2"></i> Helpdesk</a></li>
                    </ul>
                </div>

                <?php if ($_SESSION['role'] === 'admin'): ?>
                <div class="col">
                    <h6 class="text-white mb-3">Admin Tools</h6>
                    <ul class="nav flex-column">
                        <li class="nav-item mb-2"><a class="nav-link p-0 text-white dropdown-toggle" href="#asetSubmenuFooter" data-bs-toggle="collapse" aria-expanded="false"><i class="bi bi-server me-2"></i> Aset</a>
                            <div class="collapse ps-3" id="asetSubmenuFooter">
                                <a href="?page=assets" class="nav-link p-0 text-white"><i class="bi bi-list-task me-2"></i> Kelola Aset</a>
                                <a href="?page=add_asset" class="nav-link p-0 text-white"><i class="bi bi-plus-circle me-2"></i> Tambah Aset</a>
                            </div>
                        </li>
                        <li class="nav-item mb-2"><a href="?page=reports" class="nav-link p-0 text-white"><i class="bi bi-graph-up me-2"></i> Laporan</a></li>
                        <li class="nav-item mb-2"><a href="?page=tickets" class="nav-link p-0 text-white"><i class="bi bi-ticket-fill me-2"></i> Ticketing</a></li>
                    </ul>
                </div>

                <div class="col">
                    <h6 class="text-white mb-3">SLA & User</h6>
                    <ul class="nav flex-column">
                        <li class="nav-item mb-2"><a class="nav-link p-0 text-white dropdown-toggle" href="#slaSubmenuFooter" data-bs-toggle="collapse" aria-expanded="false"><i class="bi bi-clipboard-check me-2"></i> Manajemen SLA</a>
                            <div class="collapse ps-3" id="slaSubmenuFooter">
                                <a href="?page=sla_vendors" class="nav-link p-0 text-white"><i class="bi bi-building me-2"></i> Manajemen Vendor</a>
                                <a href="?page=sla_incidents" class="nav-link p-0 text-white"><i class="bi bi-exclamation-triangle me-2"></i> Manajemen Insiden</a>
                            </div>
                        </li>
                        <li class="nav-item mb-2"><a href="?page=users" class="nav-link p-0 text-white"><i class="bi bi-people me-2"></i> Kelola User</a></li>
                    </ul>
                </div>

                <div class="col">
                    <h6 class="text-white mb-3">KPI & Survey</h6>
                    <ul class="nav flex-column">
                        <li class="nav-item mb-2"><a href="?page=kpi_it" class="nav-link p-0 text-white"><i class="bi bi-bar-chart-line me-2"></i> KPI IT</a></li>
                        <li class="nav-item mb-2"><a href="?page=kpi_manual_input_form" class="nav-link p-0 text-white"><i class="bi bi-pencil-square me-2"></i> Input Manual KPI</a></li>
                        <li class="nav-item mb-2"><a href="?page=survey_results" class="nav-link p-0 text-white"><i class="bi bi-journal-check me-2"></i> Hasil Kuesioner</a></li>
                        <li class="nav-item mb-2"><a href="?page=logout" class="nav-link p-0 text-white"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
            <div class="d-flex justify-content-between align-items-center py-3 border-top border-secondary-subtle">
                <span class="text-muted small">&copy; <?php echo date("Y"); ?> SI-INAL Asset IT</span>
            </div>
        </div>
    </footer>
    <?php endif; ?>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <script src="/SI-INAL/public/assets/js/main.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var sidebarToggleMobile = document.getElementById('sidebarToggleMobile');
            var sidebarToggleDesktop = document.getElementById('sidebarToggleDesktop');
            var wrapper = document.getElementById('wrapper');

            if (sidebarToggleMobile) {
                sidebarToggleMobile.addEventListener('click', function(e) {
                    e.preventDefault();
                    wrapper.classList.toggle('toggled');
                });
            }
            if (sidebarToggleDesktop) {
                sidebarToggleDesktop.addEventListener('click', function(e) {
                    e.preventDefault();
                    wrapper.classList.toggle('toggled');
                });
            }
        });
    </script>
</body>
</html>
