<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800 fw-bold">Input Manual KPI</h1>

    <?php if (isset($_GET['message']) && $_GET['message'] == 'input_success'): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            Input KPI manual berhasil disimpan!
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'empty_fields':
                        echo "Semua kolom harus diisi.";
                        break;
                    case 'input_failed':
                        echo "Gagal menyimpan input KPI manual. Silakan coba lagi.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card card-neumorphic mb-4">
        <div class="card-header bg-transparent border-0 py-3">
            <h6 class="m-0 fw-bold text-dark">Form Input KPI Manual</h6>
        </div>
        <div class="card-body">
            <form action="?page=kpi_process_manual_input" method="POST">
                <div class="mb-3">
                    <label for="kpi_name" class="form-label">Nama KPI:</label>
                    <select class="form-select" id="kpi_name" name="kpi_name" required>
                        <option value="">-- Pilih KPI --</option>
                        <option value="Biaya Pengadaan Tinta">Biaya Pengadaan Tinta</option>
                        <option value="Sosialisasi Perubahan Sistem">Sosialisasi Perubahan Sistem</option>
                        <option value="Penerapan 5R">Penerapan 5R</option>
                        <option value="Implementasi Kaizen">Implementasi Lean Management (Kaizen)</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="value" class="form-label">Nilai / Deskripsi:</label>
                    <input type="text" class="form-control" id="value" name="value" placeholder="Masukkan nilai atau deskripsi KPI" required>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="month" class="form-label">Bulan:</label>
                        <select class="form-select" id="month" name="month" required>
                            <?php for ($i = 1; $i <= 12; $i++): ?>
                                <option value="<?php echo $i; ?>" <?php echo (date('n') == $i) ? 'selected' : ''; ?>>
                                    <?php echo date('F', mktime(0, 0, 0, $i, 10)); ?>
                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="year" class="form-label">Tahun:</label>
                        <select class="form-select" id="year" name="year" required>
                            <?php for ($i = date('Y') - 2; $i <= date('Y') + 1; $i++): ?>
                                <option value="<?php echo $i; ?>" <?php echo (date('Y') == $i) ? 'selected' : ''; ?>>
                                    <?php echo $i; ?>
                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary btn-neumorphic-sm">Simpan Input KPI</button>
                <a href="?page=kpi_it" class="btn btn-warning btn-neumorphic-sm">Batal</a>
            </form>
        </div>
    </div>

    <div class="card card-neumorphic mb-4">
        <div class="card-header bg-transparent border-0 py-3">
            <h6 class="m-0 fw-bold text-dark">Riwayat Input KPI Manual</h6>
        </div>
        <div class="card-body">
            <?php if (!empty($history)): ?>
                <div class="table-responsive">
                    <table class="table table-hover" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Nama KPI</th>
                                <th>Nilai</th>
                                <th>Bulan</th>
                                <th>Tahun</th>
                                <th>Tanggal Input</th>
                                <th>Terakhir Diperbarui</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($history as $record): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($record['kpi_name']); ?></td>
                                    <td><?php echo htmlspecialchars($record['value']); ?></td>
                                    <td><?php echo date('F', mktime(0, 0, 0, $record['month'], 10)); ?></td>
                                    <td><?php echo htmlspecialchars($record['year']); ?></td>
                                    <td><?php echo htmlspecialchars(date('d-m-Y H:i', strtotime($record['created_at']))); ?></td>
                                    <td><?php echo htmlspecialchars(date('d-m-Y H:i', strtotime($record['updated_at']))); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info">Belum ada riwayat input KPI manual.</div>
            <?php endif; ?>
        </div>
    </div>
</div>
