<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Report Problem - SI-INAL Asset IT</title>
    <!-- Inter Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="/SI-INAL/public/assets/css/style.css">
    <style>
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background-color: var(--light-bg); /* Use the light neumorphic background */
            padding: 1rem;
        }
        .card {
            border-radius: 1rem;
            box-shadow: var(--neumorphic-shadow-light); /* Use the defined neumorphic shadow */
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <!-- Existing report form content, removed the vh-100 and bg-light-neumorphic from outer div -->
                <div class="card card-neumorphic p-4">
                    <div class="card-body">
                        <h3 class="card-title text-center mb-4 fw-bold">Laporkan Masalah Aset IT</h3>
                        <p class="text-center text-muted mb-4">Mohon isi formulir di bawah untuk melaporkan masalah pada aset ini. Tidak perlu login.</p>

                        <?php if (isset($_GET['message']) && $_GET['message'] == 'report_success'): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                Laporan masalah berhasil dikirim! Terima kasih.
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <?php if (isset($_GET['error'])): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php
                                    switch ($_GET['error']) {
                                        case 'empty_fields':
                                            echo "Nama pelapor dan deskripsi masalah harus diisi.";
                                            break;
                                        case 'submit_failed':
                                            echo "Gagal mengirim laporan masalah. Silakan coba lagi.";
                                            break;
                                        case 'asset_id_missing':
                                            echo "ID Aset tidak ditemukan. Pastikan Anda memindai QR code yang valid.";
                                            break;
                                    }
                                ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>

                                    <form action="?page=helpdesk_submit_report" method="POST">
                                        <div class="mb-3">
                                            <label for="category" class="form-label">Kategori Masalah</label>
                                            <select class="form-select" id="category" name="category" required>
                                                <option value="">Pilih Kategori</option>
                                                <option value="Hardware">Hardware</option>
                                                <option value="SIMRS">SIMRS</option>
                                                <option value="Software">Software</option>
                                            </select>
                                        </div>
                        
                                        <div class="mb-3">
                                            <label for="reporter_name" class="form-label">Nama Anda:</label>
                                            <input type="text" class="form-control" id="reporter_name" name="reporter_name" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="unit" class="form-label">Unit Anda:</label>
                                            <input type="text" class="form-control" id="unit" name="unit" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="problem_description" class="form-label">Deskripsi Masalah:</label>
                                            <textarea class="form-control" id="problem_description" name="problem_description" rows="4" required></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <label for="priority" class="form-label">Prioritas:</label>
                                            <select class="form-select" id="priority" name="priority">
                                                <option value="Low">Rendah</option>
                                                <option value="Medium" selected>Sedang</option>
                                                <option value="High">Tinggi</option>
                                                <option value="Critical">Kritis</option>
                                            </select>
                                        </div>
                                        <div class="d-grid gap-2">
                                            <button type="submit" class="btn btn-primary btn-neumorphic-sm py-2">Kirim Laporan</button>
                                        </div>
                                    </form>                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>