<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Daftar Tiket Helpdesk</h1>

    <div class="d-flex justify-content-between align-items-center mb-3">
        <!-- QR Code button -->
        <button type="button" class="btn btn-info btn-neumorphic-sm" data-bs-toggle="modal" data-bs-target="#qrHelpdeskModal">
            <i class="bi bi-qr-code-scan me-2"></i> QR Code Laporan Helpdesk
        </button>

        <!-- Unduh Laporan button -->
        <a href="?page=helpdesk_report_download&<?php echo http_build_query($filters); ?>" class="btn btn-success btn-neumorphic-sm">
            <i class="bi bi-download me-2"></i> Unduh Laporan
        </a>
    </div>

    <!-- Filter Form -->
    <div class="card card-neumorphic mb-4">
        <div class="card-header bg-transparent border-0 py-3">
            <h6 class="m-0 fw-bold text-dark">Filter Tiket</h6>
        </div>
        <div class="card-body">
            <form action="?page=helpdesk_tickets" method="GET" class="row g-3 align-items-end">
                <input type="hidden" name="page" value="helpdesk_tickets">
                <div class="col-md-3">
                    <label for="date_filter" class="form-label">Tanggal</label>
                    <input type="date" class="form-control" id="date_filter" name="date_filter" value="<?php echo htmlspecialchars($filters['date_filter'] ?? ''); ?>">
                </div>
                <div class="col-md-3">
                    <label for="status_filter" class="form-label">Status</label>
                    <select class="form-select" id="status_filter" name="status_filter">
                        <option value="">Semua Status</option>
                        <option value="New" <?php echo (isset($filters['status_filter']) && $filters['status_filter'] == 'New') ? 'selected' : ''; ?>>New</option>
                        <option value="In Progress" <?php echo (isset($filters['status_filter']) && $filters['status_filter'] == 'In Progress') ? 'selected' : ''; ?>>In Progress</option>
                        <option value="Resolved" <?php echo (isset($filters['status_filter']) && $filters['status_filter'] == 'Resolved') ? 'selected' : ''; ?>>Resolved</option>
                        <option value="Closed" <?php echo (isset($filters['status_filter']) && $filters['status_filter'] == 'Closed') ? 'selected' : ''; ?>>Closed</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="unit_filter" class="form-label">Unit</label>
                    <input type="text" class="form-control" id="unit_filter" name="unit_filter" placeholder="Filter berdasarkan unit" value="<?php echo htmlspecialchars($filters['unit_filter'] ?? ''); ?>">
                </div>
                <div class="col-md-3 d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary btn-neumorphic-sm me-2">Filter</button>
                    <a href="?page=helpdesk_tickets" class="btn btn-warning btn-neumorphic-sm">Reset</a>
                </div>
            </form>
        </div>
    </div>
    <!-- End Filter Form -->

    <!-- Modal for Helpdesk QR Code -->
    <div class="modal fade" id="qrHelpdeskModal" tabindex="-1" aria-labelledby="qrHelpdeskModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content card-neumorphic">
                <div class="modal-header border-0 pb-0">
                    <h5 class="modal-title fw-bold" id="qrHelpdeskModalLabel">QR Code Laporan Helpdesk</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Scan QR Code di bawah atau gunakan link berikut:</p>
                    <a href="http://localhost/SI-INAL/public/index.php?page=helpdesk_report_form" target="_blank" id="helpdeskQrLink">
http://localhost/SI-INAL/public/index.php?page=helpdesk_report_form
                    </a>
                    <div class="my-3">
                        <!-- QR Code Image will be loaded here dynamically or from API -->
                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=http://localhost/SI-INAL/public/index.php?page=helpdesk_report_form" alt="QR Code Helpdesk" class="img-fluid">
                    </div>
                    <button class="btn btn-outline-secondary btn-sm" onclick="copyToClipboard('helpdeskQrLink')"><i class="bi bi-copy me-2"></i> Salin Link</button>
                </div>
                <div class="modal-footer border-0 pt-0">
                    <button type="button" class="btn btn-secondary btn-neumorphic-sm" data-bs-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>
    <!-- End Modal -->

    <?php if (isset($_GET['message'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['message']) {
                    case 'update_success':
                        echo "Tiket berhasil diperbarui.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php
                switch ($_GET['error']) {
                    case 'ticket_id_missing':
                        echo "ID Tiket tidak ditemukan.";
                        break;
                    case 'ticket_not_found':
                        echo "Tiket tidak ditemukan.";
                        break;
                    case 'update_failed':
                        echo "Gagal memperbarui tiket. Silakan coba lagi.";
                        break;
                }
            ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card card-neumorphic mb-4">
        <div class="card-header bg-transparent border-0 py-3">
            <h6 class="m-0 fw-bold text-dark">Semua Tiket</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID Tiket</th>
                            <th>Kategori</th>
                            <th>Unit</th>
                            <th>Pelapor</th>
                            <th>Deskripsi Masalah</th>
                            <th>Prioritas</th>
                            <th>Status</th>
                            <th>Dibuat</th>
                            <th>Waktu Respons</th> <!-- New -->
                            <th>Ditugaskan ke</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($tickets)): ?>
                            <?php foreach ($tickets as $ticket): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($ticket['id_ticket']); ?></td>
                                    <td><?php echo htmlspecialchars($ticket['category']); ?></td>
                                    <td><?php echo htmlspecialchars($ticket['unit']); ?></td>
                                    <td><?php echo htmlspecialchars($ticket['reporter_name']); ?></td>
                                    <td><?php echo substr(htmlspecialchars($ticket['problem_description']), 0, 50); ?>...</td>
                                    <td>
                                        <?php
                                            $priority_badge = '';
                                            switch ($ticket['priority']) {
                                                case 'Low': $priority_badge = 'info'; break;
                                                case 'Medium': $priority_badge = 'warning'; break;
                                                case 'High': $priority_badge = 'danger'; break;
                                                case 'Critical': $priority_badge = 'dark'; break;
                                            }
                                        ?>
                                        <span class="badge bg-<?php echo $priority_badge; ?>"><?php echo htmlspecialchars($ticket['priority']); ?></span>
                                    </td>
                                    <td>
                                        <?php
                                            $status_badge = '';
                                            switch ($ticket['status']) {
                                                case 'New': $status_badge = 'primary'; break;
                                                case 'In Progress': $status_badge = 'warning'; break;
                                                case 'Resolved': $status_badge = 'success'; break;
                                                case 'Closed': $status_badge = 'secondary'; break;
                                            }
                                        ?>
                                        <span class="badge bg-<?php echo $status_badge; ?>"><?php echo htmlspecialchars($ticket['status']); ?></span>
                                    </td>
                                    <td><?php echo htmlspecialchars(date('d-m-Y H:i', strtotime($ticket['created_at']))); ?></td>
                                    <td><?php echo htmlspecialchars($ticket['response_time']); ?></td> <!-- New -->
                                    <td><?php echo htmlspecialchars($ticket['assigned_to_name'] ?? 'Belum Ditugaskan'); ?></td>
                                    <td>
                                        <a href="?page=helpdesk_view_ticket&id=<?php echo htmlspecialchars($ticket['id_ticket']); ?>" class="btn btn-primary btn-sm btn-neumorphic-sm">Lihat/Edit</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="10" class="text-center">Tidak ada tiket helpdesk yang ditemukan.</td> <!-- Colspan adjusted from 9 to 10 -->
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>