<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print All QR Codes</title>
    <!-- Bootstrap CSS for basic styling -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <style>
        body {
            font-family: sans-serif;
            margin: 20px;
        }
        .qr-item {
            display: inline-block;
            text-align: center;
            margin: 10px;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 8px;
            background-color: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            page-break-inside: avoid; /* Prevent breaking QR codes across pages */
        }
        .qr-item img {
            display: block;
            margin: 0 auto 5px auto;
            width: 120px;
            height: 120px;
        }
        .qr-item p {
            font-size: 0.8em;
            margin: 0;
            color: #333;
        }
        .print-header {
            text-align: center;
            margin-bottom: 20px;
            display: none; /* Hidden by default, shown in print media */
        }

        /* Print-specific styles */
        @media print {
            body {
                margin: 0;
                padding: 0;
            }
            .qr-item {
                border: none;
                box-shadow: none;
                margin: 5mm;
            }
            .print-header {
                display: block;
            }
            button {
                display: none; /* Hide print button when printing */
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="print-header">
            <h1>Daftar QR Code Aset IT</h1>
            <p>Tanggal Cetak: <?php echo date('d-m-Y H:i:s'); ?></p>
        </div>

        <button onclick="window.print()" class="btn btn-primary mb-3">Cetak QR Codes</button>
        <a href="?page=assets" class="btn btn-secondary mb-3">Kembali ke Daftar Aset</a>
        
        <div class="row">
            <?php if (!empty($assets)): ?>
                <?php foreach ($assets as $asset): ?>
                    <div class="col-6 col-md-4 col-lg-3">
                        <div class="qr-item">
                            <img src="<?php echo htmlspecialchars($asset['qr_code']); ?>" alt="QR Code for <?php echo htmlspecialchars($asset['nama_perangkat']); ?>">
                            <p><strong>ID:</strong> <?php echo htmlspecialchars($asset['id_aset']); ?></p>
                            <p><strong>Nama:</strong> <?php echo htmlspecialchars($asset['nama_perangkat']); ?></p>
                            <p><strong>S/N:</strong> <?php echo htmlspecialchars($asset['serial_number']); ?></p>
                            <p><strong>Lokasi:</strong> <?php echo htmlspecialchars($asset['lokasi']); ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="alert alert-warning">Tidak ada aset dengan QR Code yang ditemukan.</div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>