<?php

class Vendor {
    private $conn;
    private $table_name = "vendors";

    public $id_vendor;
    public $nama_vendor;
    public $jenis_layanan;
    public $pic_vendor;
    public $kontak_vendor;
    public $sla_uptime_percentage;
    public $sla_response_time_minutes;

    public function __construct($db) {
        $this->conn = $db;
    }
    
    public function create() {
        $query = "INSERT INTO " . $this->table_name . " SET nama_vendor=:nama_vendor, jenis_layanan=:jenis_layanan, pic_vendor=:pic_vendor, kontak_vendor=:kontak_vendor, sla_uptime_percentage=:sla_uptime_percentage, sla_response_time_minutes=:sla_response_time_minutes";
        $stmt = $this->conn->prepare($query);

        // Sanitize
        $this->nama_vendor=htmlspecialchars(strip_tags($this->nama_vendor));
        $this->jenis_layanan=htmlspecialchars(strip_tags($this->jenis_layanan));
        $this->pic_vendor=htmlspecialchars(strip_tags($this->pic_vendor));
        $this->kontak_vendor=htmlspecialchars(strip_tags($this->kontak_vendor));
        $this->sla_uptime_percentage=htmlspecialchars(strip_tags($this->sla_uptime_percentage));
        $this->sla_response_time_minutes=htmlspecialchars(strip_tags($this->sla_response_time_minutes));

        // Bind
        $stmt->bindParam(":nama_vendor", $this->nama_vendor);
        $stmt->bindParam(":jenis_layanan", $this->jenis_layanan);
        $stmt->bindParam(":pic_vendor", $this->pic_vendor);
        $stmt->bindParam(":kontak_vendor", $this->kontak_vendor);
        $stmt->bindParam(":sla_uptime_percentage", $this->sla_uptime_percentage);
        $stmt->bindParam(":sla_response_time_minutes", $this->sla_response_time_minutes);

        if($stmt->execute()){
            return true;
        }
        return false;
    }
    
    public function read() {
        $query = "SELECT * FROM " . $this->table_name . " ORDER BY nama_vendor ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
}
