<?php

class User {
    private $conn;
    private $table_name = "users";

    public $id_user;
    public $username;
    public $password;
    public $nama_lengkap;
    public $role;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get user by username
    public function getByUsername() {
        $query = "SELECT * FROM " . $this->table_name . " WHERE username = :username LIMIT 0,1";
        $stmt = $this->conn->prepare($query);

        // Sanitize and bind
        $this->username = htmlspecialchars(strip_tags($this->username));
        $stmt->bindParam(':username', $this->username);
        
        $stmt->execute();
        
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->id_user = $row['id_user'];
            $this->password = $row['password'];
            $this->nama_lengkap = $row['nama_lengkap'];
            $this->role = $row['role'];
            return true;
        }
        return false;
    }

    // Get user by ID
    public function getById() {
        $query = "SELECT * FROM " . $this->table_name . " WHERE id_user = :id_user LIMIT 0,1";
        $stmt = $this->conn->prepare($query);

        // Sanitize and bind
        $this->id_user = htmlspecialchars(strip_tags($this->id_user));
        $stmt->bindParam(':id_user', $this->id_user);
        
        $stmt->execute();
        
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->id_user = $row['id_user'];
            $this->username = $row['username'];
            $this->password = $row['password'];
            $this->nama_lengkap = $row['nama_lengkap'];
            $this->role = $row['role'];
            return true;
        }
        return false;
    }

    // Get all users
    public function getAllUsers() {
        $query = "SELECT id_user, username, nama_lengkap, role FROM " . $this->table_name . " ORDER BY nama_lengkap ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Add new user
    public function add() {
        $query = "INSERT INTO " . $this->table_name . "
                  SET
                    username = :username,
                    password = :password,
                    nama_lengkap = :nama_lengkap,
                    role = :role";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind
        $this->username = htmlspecialchars(strip_tags($this->username));
        $this->password = htmlspecialchars(strip_tags($this->password));
        $this->nama_lengkap = htmlspecialchars(strip_tags($this->nama_lengkap));
        $this->role = htmlspecialchars(strip_tags($this->role));

        $stmt->bindParam(':username', $this->username);
        $stmt->bindParam(':password', $this->password);
        $stmt->bindParam(':nama_lengkap', $this->nama_lengkap);
        $stmt->bindParam(':role', $this->role);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    // Update a user
    public function update() {
        $query = "UPDATE " . $this->table_name . "
                  SET
                    username = :username,
                    password = :password,
                    nama_lengkap = :nama_lengkap,
                    role = :role
                  WHERE
                    id_user = :id_user";

        $stmt = $this->conn->prepare($query);

        // Sanitize and bind
        $this->id_user = htmlspecialchars(strip_tags($this->id_user));
        $this->username = htmlspecialchars(strip_tags($this->username));
        $this->password = htmlspecialchars(strip_tags($this->password));
        $this->nama_lengkap = htmlspecialchars(strip_tags($this->nama_lengkap));
        $this->role = htmlspecialchars(strip_tags($this->role));

        $stmt->bindParam(':id_user', $this->id_user);
        $stmt->bindParam(':username', $this->username);
        $stmt->bindParam(':password', $this->password);
        $stmt->bindParam(':nama_lengkap', $this->nama_lengkap);
        $stmt->bindParam(':role', $this->role);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    // Delete a user
    public function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id_user = :id_user";
        $stmt = $this->conn->prepare($query);

        // Sanitize and bind
        $this->id_user = htmlspecialchars(strip_tags($this->id_user));
        $stmt->bindParam(':id_user', $this->id_user);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }
}