<?php

class Asset {
    private $conn;
    private $table_name = "assets";

    public $id_aset;
    public $nama_perangkat;
    public $kategori;
    public $serial_number;
    public $lokasi;
    public $pic;
    public $tanggal_pembelian;
    public $nilai_pembelian;
    public $life_cycle_years;
    public $status_aset;
    public $qr_code;
    public $created_at;
    public $updated_at;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Create asset
    public function create() {
        $query = "INSERT INTO " . $this->table_name . "
                  SET
                    nama_perangkat=:nama_perangkat,
                    kategori=:kategori,
                    serial_number=:serial_number,
                    lokasi=:lokasi,
                    pic=:pic,
                    tanggal_pembelian=:tanggal_pembelian,
                    nilai_pembelian=:nilai_pembelian,
                    life_cycle_years=:life_cycle_years,
                    status_aset=:status_aset";

        $stmt = $this->conn->prepare($query);

        // sanitize
        $this->nama_perangkat = htmlspecialchars(strip_tags($this->nama_perangkat));
        $this->kategori = htmlspecialchars(strip_tags($this->kategori));
        $this->serial_number = htmlspecialchars(strip_tags($this->serial_number));
        $this->lokasi = htmlspecialchars(strip_tags($this->lokasi));
        $this->pic = htmlspecialchars(strip_tags($this->pic));
        $this->tanggal_pembelian = htmlspecialchars(strip_tags($this->tanggal_pembelian));
        $this->nilai_pembelian = htmlspecialchars(strip_tags($this->nilai_pembelian));
        $this->life_cycle_years = htmlspecialchars(strip_tags($this->life_cycle_years));
        $this->status_aset = htmlspecialchars(strip_tags($this->status_aset));

        // bind values
        $stmt->bindParam(":nama_perangkat", $this->nama_perangkat);
        $stmt->bindParam(":kategori", $this->kategori);
        $stmt->bindParam(":serial_number", $this->serial_number);
        $stmt->bindParam(":lokasi", $this->lokasi);
        $stmt->bindParam(":pic", $this->pic);
        $stmt->bindParam(":tanggal_pembelian", $this->tanggal_pembelian);
        $stmt->bindParam(":nilai_pembelian", $this->nilai_pembelian);
        $stmt->bindParam(":life_cycle_years", $this->life_cycle_years);
        $stmt->bindParam(":status_aset", $this->status_aset);

        if ($stmt->execute()) {
            $this->id_aset = $this->conn->lastInsertId();
            return true;
        }

        return false;
    }

    // Read all assets
    public function read() {
        $query = "SELECT
                    id_aset, nama_perangkat, kategori, serial_number, lokasi,
                    pic, tanggal_pembelian, nilai_pembelian, life_cycle_years,
                    status_aset, qr_code, created_at, updated_at
                  FROM
                    " . $this->table_name . "
                  ORDER BY
                    created_at DESC";

        $stmt = $this->conn->prepare($query);
        $stmt->execute();

        return $stmt;
    }

    // Read single asset
    public function readOne() {
        $query = "SELECT
                    id_aset, nama_perangkat, kategori, serial_number, lokasi,
                    pic, tanggal_pembelian, nilai_pembelian, life_cycle_years,
                    status_aset, qr_code, created_at, updated_at
                  FROM
                    " . $this->table_name . "
                  WHERE
                    id_aset = ?
                  LIMIT
                    0,1";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id_aset);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->nama_perangkat = $row['nama_perangkat'];
            $this->kategori = $row['kategori'];
            $this->serial_number = $row['serial_number'];
            $this->lokasi = $row['lokasi'];
            $this->pic = $row['pic'];
            $this->tanggal_pembelian = $row['tanggal_pembelian'];
            $this->nilai_pembelian = $row['nilai_pembelian'];
            $this->life_cycle_years = $row['life_cycle_years'];
            $this->status_aset = $row['status_aset'];
            $this->qr_code = $row['qr_code'];
            $this->created_at = $row['created_at'];
            $this->updated_at = $row['updated_at'];
            return true;
        }
        return false;
    }

    // Update asset
    public function update() {
        $query = "UPDATE " . $this->table_name . "
                  SET
                    nama_perangkat=:nama_perangkat,
                    kategori=:kategori,
                    serial_number=:serial_number,
                    lokasi=:lokasi,
                    pic=:pic,
                    tanggal_pembelian=:tanggal_pembelian,
                    nilai_pembelian=:nilai_pembelian,
                    life_cycle_years=:life_cycle_years,
                    status_aset=:status_aset,
                    qr_code=:qr_code
                  WHERE
                    id_aset = :id_aset";

        $stmt = $this->conn->prepare($query);

        // sanitize and bind values (similar to create, but include id_aset)
        $this->id_aset = htmlspecialchars(strip_tags($this->id_aset));
        $this->nama_perangkat = htmlspecialchars(strip_tags($this->nama_perangkat));
        $this->kategori = htmlspecialchars(strip_tags($this->kategori));
        $this->serial_number = htmlspecialchars(strip_tags($this->serial_number));
        $this->lokasi = htmlspecialchars(strip_tags($this->lokasi));
        $this->pic = htmlspecialchars(strip_tags($this->pic));
        $this->tanggal_pembelian = htmlspecialchars(strip_tags($this->tanggal_pembelian));
        $this->nilai_pembelian = htmlspecialchars(strip_tags($this->nilai_pembelian));
        $this->life_cycle_years = htmlspecialchars(strip_tags($this->life_cycle_years));
        $this->status_aset = htmlspecialchars(strip_tags($this->status_aset));
        $this->qr_code = htmlspecialchars(strip_tags($this->qr_code));

        $stmt->bindParam(':id_aset', $this->id_aset);
        $stmt->bindParam(':nama_perangkat', $this->nama_perangkat);
        $stmt->bindParam(':kategori', $this->kategori);
        $stmt->bindParam(':serial_number', $this->serial_number);
        $stmt->bindParam(':lokasi', $this->lokasi);
        $stmt->bindParam(':pic', $this->pic);
        $stmt->bindParam(':tanggal_pembelian', $this->tanggal_pembelian);
        $stmt->bindParam(':nilai_pembelian', $this->nilai_pembelian);
        $stmt->bindParam(':life_cycle_years', $this->life_cycle_years);
        $stmt->bindParam(':status_aset', $this->status_aset);
        $stmt->bindParam(':qr_code', $this->qr_code);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    // Delete asset
    public function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id_aset = ?";
        $stmt = $this->conn->prepare($query);

        $this->id_aset = htmlspecialchars(strip_tags($this->id_aset));
        $stmt->bindParam(1, $this->id_aset);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    // Get total count of assets
    public function getAssetCount() {
        $query = "SELECT COUNT(*) as count FROM " . $this->table_name;
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC)['count'];
    }

    // Get count of assets by status
    public function getAssetCountByStatus($status) {
        $query = "SELECT COUNT(*) as count FROM " . $this->table_name . " WHERE status_aset = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $status);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC)['count'];
    }
}
