<?php
require_once dirname(__DIR__) . '/models/User.php';
require_once dirname(__DIR__) . '/../config/db.php';

class UserController {
    private $db;
    private $user;

    public function __construct() {
        $this->db = connectDB();
        $this->user = new User($this->db);
    }

    public function index() {
        $users = $this->user->getAllUsers();
        require_once dirname(__DIR__) . '/../views/users/index.php';
    }

    public function create() {
        require_once dirname(__DIR__) . '/../views/users/create.php';
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $this->user->username = htmlspecialchars(strip_tags($_POST['username']));
            $this->user->nama_lengkap = htmlspecialchars(strip_tags($_POST['nama_lengkap']));
            $password = $_POST['password'];
            $this->user->role = htmlspecialchars(strip_tags($_POST['role']));

            if (empty($this->user->username) || empty($this->user->nama_lengkap) || empty($password) || empty($this->user->role)) {
                header("Location: ?page=users_create&error=empty_fields");
                exit();
            }

            if ($this->user->getByUsername()) { // Check if username already exists
                header("Location: ?page=users_create&error=username_exists");
                exit();
            }

            $this->user->password = password_hash($password, PASSWORD_DEFAULT);

            if ($this->user->add()) {
                header("Location: ?page=users&message=user_added");
                exit();
            } else {
                header("Location: ?page=users_create&error=add_failed");
                exit();
            }
        }
    }

    public function edit() {
        $id = $_GET['id'] ?? null;
        if (!$id) {
            header("Location: ?page=users");
            exit();
        }
        $this->user->id_user = $id;
        if ($this->user->getById()) {
            $user_data = $this->user;
            require_once dirname(__DIR__) . '/../views/users/edit.php';
        } else {
            header("Location: ?page=users&error=user_not_found");
            exit();
        }
    }

    public function update() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $this->user->id_user = $_POST['id_user'];
            $this->user->username = htmlspecialchars(strip_tags($_POST['username']));
            $this->user->nama_lengkap = htmlspecialchars(strip_tags($_POST['nama_lengkap']));
            $this->user->role = htmlspecialchars(strip_tags($_POST['role']));
            $password = $_POST['password']; // Optional password update

            if (empty($this->user->username) || empty($this->user->nama_lengkap) || empty($this->user->role)) {
                header("Location: ?page=users_edit&id=" . $this->user->id_user . "&error=empty_fields");
                exit();
            }

            // If password is provided, hash and update it
            if (!empty($password)) {
                $this->user->password = password_hash($password, PASSWORD_DEFAULT);
            } else {
                // Keep existing password if not provided
                $old_user = new User($this->db);
                $old_user->id_user = $this->user->id_user;
                $old_user->getById();
                $this->user->password = $old_user->password;
            }
            
            if ($this->user->update()) {
                header("Location: ?page=users&message=user_updated");
                exit();
            } else {
                header("Location: ?page=users_edit&id=" . $this->user->id_user . "&error=update_failed");
                exit();
            }
        }
    }

    public function delete() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $this->user->id_user = $_POST['id_user'];
            if ($this->user->delete()) {
                header("Location: ?page=users&message=user_deleted");
                exit();
            } else {
                header("Location: ?page=users&error=delete_failed");
                exit();
            }
        }
    }
}